package gov.va.vamf.scheduling.varutility.linkbuilder;

import com.agilex.healthcare.mobilehealthplatform.domain.AtomLink;
import gov.va.vamf.scheduling.varutility.domain.DirectBookingEligibilityCriteria;
import gov.va.vamf.scheduling.varutility.domain.RequestEligibilityCriteria;

import javax.ws.rs.core.UriBuilder;
import java.net.URI;

public class LinkBuilder {
    public static void fillLink(DirectBookingEligibilityCriteria i, URI requestUri) {
        if(i != null) {
            AtomLink link = new AtomLink();
            URI href = UriBuilder.fromUri(getBaseUri(requestUri)).path("id").path(i.getId()).build();
            link.setTitle("direct-booking-eligibility-criteria");
            link.setHref(href);
            i.getLink().clear();
            i.getLink().add(link);
        }
    }

    public static void fillLink(RequestEligibilityCriteria r, URI requestUri) {
        if(r != null) {
            AtomLink link = new AtomLink();
            URI href = UriBuilder.fromUri(getBaseUri(requestUri)).path("id").path(r.getId()).build();
            link.setTitle("request-eligibility-criteria");
            link.setHref(href);
            r.getLink().clear();
            r.getLink().add(link);
        }
    }

    private static URI getBaseUri(URI requestUri) {
        String uriString = requestUri.toString();
        String[] uriArray = uriString.split("id");
        return URI.create(uriArray[0]);
    }
}
